#include "winlink.h"

#include <direct.h>

extern void AdMame2x(u8 *srcPtr, u32 srcPitch, u8 * /* deltaPtr */,
					 u8 *dstPtr, u32 dstPitch, int width, int height);
extern void Simple2x(u8 *srcPtr, u32 srcPitch, u8 * /* deltaPtr */,
					 u8 *dstPtr, u32 dstPitch, int width, int height);


void nSimple2x(u8 *srcPtr, u32 srcPitch, u8 * /* deltaPtr */,
			   u8 *dstPtr, u32 dstPitch, int width, int height)
{
	u8 *nextLine, *finish;

	nextLine = dstPtr + dstPitch;

	do {
		u32 *bP = (u32 *) srcPtr;
		u32 *dP = (u32 *) dstPtr;
		u32 *nL = (u32 *) nextLine;
		u32 currentPixel;

		finish = (u8 *) bP + ((width+2) << 1);
		currentPixel = *bP++;

		do {
			//#ifdef WORDS_BIGENDIAN
			//      u32 color = currentPixel >> 16;
			//#else
			u32 color = currentPixel & 0xffff;
			//#endif

			color = color | (color << 16);

			*(dP) = color;
			*(nL) = color;

			//#ifdef WORDS_BIGENDIAN
			//   color = currentPixel & 0xffff;
			//#else
			color = currentPixel >> 16;
			//#endif
			color = color| (color << 16);      
			*(dP + 1) = color;
			*(nL + 1) = color;

			currentPixel = *bP++;

			dP += 2;
			nL += 2;
		} while ((u8 *) bP < finish);

		srcPtr += srcPitch;
		dstPtr += dstPitch << 1;
		nextLine += dstPitch << 1;
	}
	while (--height);
}

/*
void checkDevices() {
DWORD dwInsertions, dwRemovals;
XGetDeviceChanges(XDEVICE_TYPE_GAMEPAD, &dwInsertions, &dwRemovals);
if( dwRemovals & (1<<0) )
{
XInputClose( ZsnesGamePad );
ZsnesGamePad = NULL;
}  
if( dwRemovals & (1<<1) )
{
XInputClose( ZsnesGamePad2 );
ZsnesGamePad2 = NULL;
}
if( dwInsertions & (1<<0) )ZsnesGamePad  = XInputOpen(XDEVICE_TYPE_GAMEPAD,XDEVICE_PORT0,XDEVICE_NO_SLOT,NULL);
if( dwInsertions & (1<<1) )ZsnesGamePad2  = XInputOpen(XDEVICE_TYPE_GAMEPAD,XDEVICE_PORT1,XDEVICE_NO_SLOT,NULL);
}
*/

BOOL InitSound()
{
	if(lpPrimaryBuffer)
		lpPrimaryBuffer->Release();

	RevStereo = ReverseStereo;
	WAVEFORMATEX wfx;
	SoundEnabled = 0;
	if (cfgsoundon == 0) { return FALSE; }
	//cfgSoundQuality = 5;
	//SoundQuality = 5;
	PrevSoundQuality=SoundQuality;
	PrevStereoSound=StereoSound;
	UsePrimaryBuffer=1;
	PrimaryBuffer=1;
	if (true)
	{
		if (PrimaryBuffer)
		{
			if (false)
			{
				if (false)
					return FALSE;
			}
			else {
				UsePrimaryBuffer=1;
			}
		}
		else
		{
			if (false)
			{
				if (false)
					return FALSE;
			}
			else 
			{
				UsePrimaryBuffer=0;
			}
		}
	}
	else
	{
		return FALSE;
	}

	wfx.wFormatTag = WAVE_FORMAT_PCM;
	//cfgSoundQuality = 5;
	//SoundQuality = 5;
	switch (SoundQuality)
	{
	case 0:
		wfx.nSamplesPerSec = 8000;
		SoundBufferSize=1024*2;
		break;
	case 1:
		wfx.nSamplesPerSec = 11025;
		SoundBufferSize=1024*2;
		break;
	case 2:
		wfx.nSamplesPerSec = 22050;
		SoundBufferSize=1024*4;
		break;
	case 3:
		//dprintf("44100\n");
		wfx.nSamplesPerSec = 44100;
		SoundBufferSize=1024*8;
		break;
	case 4:
		wfx.nSamplesPerSec = 16000;
		SoundBufferSize=1024*4;
		break;
	case 5:
		//dprintf("32000\n");
		wfx.nSamplesPerSec = 32000;
		SoundBufferSize=1024*8;
		break;
	case 6:
		//dprintf("48000\n");
		wfx.nSamplesPerSec = 48000;
		SoundBufferSize=1024*8;
		break;
	default:
		wfx.nSamplesPerSec = 11025;
		SoundBufferSize=1024*2;
	}
	if (StereoSound==1)
	{
		//dprintf("Stereo\n");
		wfx.nChannels = 2;
		wfx.nBlockAlign = 4;
		SoundBufferSize*=2;
	}
	else
	{
		//dprintf("No Stereo\n");
		wfx.nChannels = 1;
		wfx.nBlockAlign = 2;
	}
	wfx.wBitsPerSample = 16;
	wfx.nAvgBytesPerSec = wfx.nSamplesPerSec * wfx.nBlockAlign;
	wfx.cbSize=0;
	memset(&dsbd, 0, sizeof(DSBUFFERDESC));
	dsbd.dwSize = sizeof(DSBUFFERDESC);
	dsbd.dwBufferBytes = SoundBufferSize;
	dsbd.lpwfxFormat = &wfx;

	if(m_pDSound == NULL) {  return FALSE; }

	if (DS_OK == m_pDSound->CreateSoundBuffer(&dsbd, &lpPrimaryBuffer, NULL))
	{
		if(!UsePrimaryBuffer)
		{
			if (true){} else return FALSE;
		}
		else
		{
			void *mema=NULL,*memb=NULL;
			DWORD sizea=0,sizeb=0;
			lpPrimaryBuffer->Lock(0,SoundBufferSize, &mema, &sizea, &memb,&sizeb, 0);
			memset(mema,0,SoundBufferSize);
			lpPrimaryBuffer->Unlock(mema,sizea, memb,sizeb);
			if (DS_OK != lpPrimaryBuffer->Play(0,0,DSBPLAY_LOOPING)){return FALSE;}
		}
		SoundEnabled=1;
		FirstSound=0;
		return TRUE;
	}
	else
	{
		return FALSE;
	}
	return true;
}


//extern "C" begin
extern "C" {
	void FrameSemaphore(){
		if (T60HZEnabled)
		{
			double delay;
			QueryPerformanceCounter((LARGE_INTEGER*)&end);
			delay = ((update_ticks_pc - (end - start)) * 1000.0 / freq) - 3.0;
			if (delay>0.0) WaitForSingleObject(hLock, (unsigned int)delay);
		}
	}

	DWORD WINAPI SemaphoreThread( LPVOID lpParam )
	{
		while(semaphore_run)
		{
			if (T60HZEnabled)
			{
				ReleaseSemaphore(hLock, 1, NULL);
				Sleep(1);
			}
			else
				Sleep(20);
		}
		return 0;
	}

	void InitSemaphore()
	{
		if (hLock) return;
		hLock = CreateSemaphore(NULL, 1, SemaphoreMax, NULL);
		semaphore_run = 1;
		hThread = CreateThread(NULL, 0, SemaphoreThread, &dwThreadParam, 0, &dwThreadId);
	}

	void ShutdownSemaphore()
	{
		if (!hLock) return;
		semaphore_run = 0;
		WaitForSingleObject(hThread, INFINITE);
		CloseHandle(hThread);
		CloseHandle(hLock);
		hLock = NULL;
	}


	void Start60HZ(void)
	{
		update_ticks_pc2 = UPDATE_TICKS_UDP * freq / 1000.0;
		if (romispal==1)
		{
			update_ticks_pc = UPDATE_TICKS_GAMEPAL * freq / 1000.0;
		}
		else
		{
			update_ticks_pc = UPDATE_TICKS_GAME * freq / 1000.0;
		}
		QueryPerformanceCounter((LARGE_INTEGER*)&start);
		QueryPerformanceCounter((LARGE_INTEGER*)&start2);
		T36HZEnabled=0;
		T60HZEnabled=1;
		InitSemaphore();
	}

	void Stop60HZ(void)
	{
		T60HZEnabled=0;
		ShutdownSemaphore();
	}

	void Start36HZ(void)
	{
		update_ticks_pc2 = UPDATE_TICKS_UDP * freq / 1000.0;
		update_ticks_pc = UPDATE_TICKS_GUI * freq / 1000.0;
		QueryPerformanceCounter((LARGE_INTEGER*)&start);
		QueryPerformanceCounter((LARGE_INTEGER*)&start2);
		T60HZEnabled=0;
		T36HZEnabled=1;
	}

	void CheckTimers(void)
	{
		// Lame fix for GUI using 100% CPU
		if (GUIOn || GUIOn2) Sleep(1);
		QueryPerformanceCounter((LARGE_INTEGER*)&end2);
		while ((end2 - start2) >= update_ticks_pc2){start2 += update_ticks_pc2;}
		if (T60HZEnabled == 1)
		{
			QueryPerformanceCounter((LARGE_INTEGER*)&end);

			while ((end - start) >= update_ticks_pc)
			{
				Game60hzcall();
				start += update_ticks_pc;
			}
		}

		if (T36HZEnabled == 1)
		{
			QueryPerformanceCounter((LARGE_INTEGER*)&end);

			while ((end - start) >= update_ticks_pc)
			{
				GUI36hzcall();
				start += update_ticks_pc;
			}
		}
	}


	void setSurroundSound() {
		if(SurroundSound == 1) {
			Surround = 1; 

			InitSound();
			AdjustFrequency();

		}
		else {
			Surround = 0;

			InitSound();
			AdjustFrequency();

		}
	}

	void setSoundInterpolation() {
		if(SoundInterpolation == 0) {
			SoundInterpType = 1;

			InitSound();
			AdjustFrequency();

		}
		if(SoundInterpolation == 1) {
			SoundInterpType = 2;

			InitSound();
			AdjustFrequency();

		}
		if(SoundInterpolation == 2) {
			SoundInterpType = 3;

			InitSound();
			AdjustFrequency();

		}
	}


	void setLowPassFilter() {
		if(LowPassFilter == 0) {
			LowPassFilterType = 0;

			InitSound();
			AdjustFrequency();

		}
		if(LowPassFilter == 1) {
			LowPassFilterType = 1;

			InitSound();
			AdjustFrequency();

		}
		if(LowPassFilter == 2) {
			LowPassFilterType = 2;

			InitSound();
			AdjustFrequency();

		}
		if(LowPassFilter == 3) {
			LowPassFilterType = 3;

			InitSound();
			AdjustFrequency();

		}
	}

	void setFrequency() {
		if(SoundFrequency == 0) {
			SoundQuality = 5;
			cfgSoundQuality = 5;

			InitSound();
			AdjustFrequency();

		}
		else if(SoundFrequency == 1) {
			SoundQuality = 3;
			cfgSoundQuality = 3;

			InitSound();
			AdjustFrequency();

		}
		else if(SoundFrequency == 2) {
			SoundQuality = 6;
			cfgSoundQuality = 6;

			InitSound();
			AdjustFrequency();

		}
	}


	
int p1 = 0;
int p2 = 1;
int p3 = 2;
int p4 = 3;


	void initwinvideo(void)
	{
		

		
		FPSAtStart = ShowFPS; 
		FPSOn = ShowFPS;

		unsigned int color32,ScreenPtr2;
		int i, j, k, r, g, b, Y, u, v;

		 
		ScreenPtr2=BitConv32Ptr;
		for(i=0;i<65536;i++)
		{
			color32=((i&0xF800)<<8)+
				((i&0x07E0)<<5)+
				((i&0x001F)<<3)+0xFF000000;
			(*(unsigned int *)(ScreenPtr2))=color32;
			ScreenPtr2+=4;
		}

		for (i=0; i<32; i++)
			for (j=0; j<64; j++)
				for (k=0; k<32; k++)
				{
					r = i << 3;
					g = j << 2;
					b = k << 3;
					Y = (r + g + b) >> 2;
					u = 128 + ((r - b) >> 2);
					v = 128 + ((-r + 2*g -b)>>3);
					*(((unsigned int *)RGBtoYUVPtr) + (i << 11) + (j << 5) + k) = (Y<<16) + (u<<8) + v;
				}


				pl1Xtk = 210; 
				pl1Ytk = 211; 
				pl1Atk = 212; 
				pl1Btk = 213; 
				pl1Ltk = 209; 
				pl1Rtk = 214;

				pl2Xtk = 215; 
				pl2Ytk = 216; 
				pl2Atk = 217; 
				pl2Btk = 218; 
				pl2Ltk = 219; 
				pl2Rtk = 220;

				pl3Xtk = 221; 
				pl3Ytk = 222; 
				pl3Atk = 223; 
				pl3Btk = 224; 
				pl3Ltk = 225; 
				pl3Rtk = 226;

				pl4Xtk = 227; 
				pl4Ytk = 228; 
				pl4Atk = 229; 
				pl4Btk = 230; 
				pl4Ltk = 231; 
				pl4Rtk = 232;

				SPCSize=256;
				pl1selk = 40;
				pl1startk = 41;
				pl1upk = 200;
				pl1downk = 208;
				pl1leftk = 203;
				pl1rightk = 205;
				pl1Ak = 42;
				pl1Bk = 43;
				pl1Lk = 44;
				pl1Rk = 45;
				pl1Xk = 46;
				pl1Yk = 47;

				pl2upk = 26;
				pl2downk = 27;
				pl2leftk = 28;
				pl2rightk = 29;
				pl2startk = 30;
				pl2selk = 31;
				pl2Ak = 32;
				pl2Bk = 33;
				pl2Xk = 34;
				pl2Yk = 35;
				pl2Lk = 36;
				pl2Rk = 37;

				
				pl3upk = 100;
				pl3downk = 101;
				pl3leftk = 102;
				pl3rightk = 103;
				pl3startk = 104;
				pl3selk = 105;
				pl3Ak = 106;
				pl3Bk = 107;
				pl3Xk = 108;
				pl3Yk = 109;
				pl3Lk = 110;
				pl3Rk = 111;
				

				
				pl4upk = 112;
				pl4downk = 113;
				pl4leftk = 114;
				pl4rightk = 115;
				pl4startk = 116;
				pl4selk = 117;
				pl4Ak = 118;
				pl4Bk = 119;
				pl4Xk = 120;
				pl4Yk = 121;
				pl4Lk = 122;
				pl4Rk = 123;
				
				pl1contrl = 1;
				pl2contrl = 1;
				pl3contrl = Disable34;
				pl4contrl = Disable34;

				KeySaveState = 72;
				KeyLoadState = 73;
				KeyFastFrwrd = 74;
				KeyVolUp = 150;
				KeyVolDown = 151;
				KeyRewind = 153;
				KeyQuickRst = 154;
				KeyNewGfxSwt = 152;
				KeyUsePlayer1234 = 233;
				setFrequency();
				setSoundInterpolation(); 
				setLowPassFilter();
				setSurroundSound(); 
				RevStereo = ReverseStereo;
				Turbo30hz = fastTurbo;
				//KeyQuickRst = 41;


				//KeyRewind = 0;

				RECT rc1;
				DWORD newmode=0;
				DWORD HQMode=0;

				if ( hqFilter != 0 )
				{
					if ( GUIHQ2X[cvidmode] != 0 ) HQMode=2;
					if ( GUIHQ3X[cvidmode] != 0 ) HQMode=3;
					if ( GUIHQ4X[cvidmode] != 0 ) HQMode=4;
				}

				if ((CurMode!=cvidmode) || (prevHQMode!=HQMode))
				{
					CurMode=cvidmode;
					prevHQMode=HQMode;
					newmode=1;
					SurfaceX=256;
					SurfaceY=240;
					X=0;
					Y=0;
					FullScreen=GUIWFVID[cvidmode];
					DMode=GUIDSIZE[cvidmode];
					SMode=GUISMODE[cvidmode];
					DSMode=GUIDSMODE[cvidmode];

					switch (cvidmode)
					{
					case 0:
						WindowWidth=256;
						WindowHeight=224;
						break;
					case 1:
						WindowWidth=640;
						WindowHeight=480;
						break;
					case 2:
					case 3:
						WindowWidth=512;
						WindowHeight=448;
						break;
					case 4:
					case 5:
					case 6:
					case 7:
					case 8:
						WindowWidth=640;
						WindowHeight=480;
						break;
					case 9:
					case 10:
						WindowWidth=768;
						WindowHeight=672;
						break;
					case 11:
					case 12:
					case 13:
					case 14:
					case 15:
						WindowWidth=800;
						WindowHeight=600;
						break;
					case 16:
					case 17:
					case 18:
					case 19:
					case 20:
						WindowWidth=1024;
						WindowHeight=768;
						break;
					case 21:
					case 22:
						WindowWidth=1024;
						WindowHeight=896;
						break;
					case 23:
					case 24:
					case 25:
					case 26:
					case 27:
						WindowWidth=1280;
						WindowHeight=960;
						break;
					case 28:
					case 29:
					case 30:
					case 31:
					case 32:
						WindowWidth=1280;
						WindowHeight=1024;
						break;
					case 33:
					case 34:
					case 35:
					case 36:
						WindowWidth=1600;
						WindowHeight=1024;
						break;
					case 37:
						WindowWidth=1680;
						WindowHeight=1050;
						break;
					default:
						WindowWidth=256;
						WindowHeight=224;
						break;
					}

					if (DMode == 1)
					{
						if ((DSMode == 1) || (FullScreen == 0))
							SurfaceX = 512;
						else
							SurfaceX = 640;

						SurfaceY=480;
					}
					else
					{
						if ((SMode == 0) && (FullScreen == 1))
							SurfaceX=320;
						else
							SurfaceX=256;
						SurfaceY=240;
					}

					switch ( HQMode )
					{
					case 2:
						SurfaceX=512;
						SurfaceY=480;
						break;
					case 3:
						SurfaceX=768;
						SurfaceY=720;
						break;
					case 4:
						SurfaceX=1024;
						SurfaceY=960;
						break;
					}
					BlitArea.top = 0;
					BlitArea.left = 0;
					BlitArea.right = SurfaceX;
					if ((SurfaceX == 600) || (SurfaceX == 640) || (SurfaceX == 320))
						BlitArea.bottom = SurfaceY;
					else
						BlitArea.bottom = (SurfaceY/240)*resolutn;

					if (PrevRes == 0) PrevRes = resolutn;
				}

				if (((PrevStereoSound!=StereoSound)||(PrevSoundQuality!=SoundQuality))&&FirstSound!=1)
					ReInitSound();

				if (!FirstVid)
				{
					if (X<0)X=0;
					if (Y<0)Y=0;
					if (FullScreen==1) {X=0; Y=0;}
					if (FullScreen==0 && newmode == 1) { X = MainWindowX; Y = MainWindowY; }
					else if (FullScreen==0) { MainWindowX = X; MainWindowY = Y; }
					SetRect(&rc1, 0, 0, WindowWidth, WindowHeight);
					if (FullScreen == 1)
					{
						if (HQMode && !DSMode)
						{
							int marginx = (rcWindow.right - rcWindow.left - BlitArea.right + BlitArea.left)/2;
							int marginy = (rcWindow.bottom - rcWindow.top - BlitArea.bottom + BlitArea.top)/2;
							if (marginx>0)
							{
								rcWindow.left += marginx;
								rcWindow.right -= marginx;
							}
							if (marginy>0)
							{
								rcWindow.top += marginy;
								rcWindow.bottom -= marginy;
							}
						}

						if ((DSMode == 1) && (scanlines != 0))
						{
							int OldHeight = rcWindow.bottom - rcWindow.top;
							if ((OldHeight % 240) == 0)
							{
								int NewHeight = (OldHeight/240)*resolutn;
								rcWindow.top += (OldHeight - NewHeight)/2;
								rcWindow.bottom = rcWindow.top + NewHeight;
								clear_display();
							}
						}
					}
				}
				else
				{
					atexit(ExitFunction);
					if (!QueryPerformanceFrequency((LARGE_INTEGER*)&freq)) return;
					if (FullScreen==1) {X=0; Y=0;}
					if (SaveMainWindowPos == 1 && MainWindowX != -1 && FullScreen == 0) { X = MainWindowX; Y = MainWindowY; }
					CheckPriority();
					CheckAlwaysOnTop();
					CheckScreenSaver();
					InitInput();
					InitSound();
					TestJoy();
					if (debugger) InitDebugger(); // Start debugger such that it is at this point
				}

				if (FirstVid == 1)
				{
					FirstVid = 0;
					if (Force60hz) Refresh = 60;
					InitDirectDraw();
					clearwin();
					Clear2xSaIBuffer();
					clear_display();
					return;
				}

				if (Moving == 1) return;

				if (newmode == 1)
				{
					ReleaseDirectDraw();
					InitDirectDraw();
					clearwin();
					Clear2xSaIBuffer();
					clear_display();
					return;
				}
	}

	
	int getPitch() { return pitch; }
	
	void SetSPCEnable() {}

	void setHardwareFilter() {
		if(HardwareFilter == 0) {
			WCHAR textF1[80]={0};
			Device->SetTextureStageState(0, D3DTSS_MIPFILTER,D3DTEXF_NONE);
		}
		if(HardwareFilter == 1) {
			Device->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_POINT);
			Device->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_POINT);
			Device->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);

		}
		if(HardwareFilter == 2) {
			//dprintf("Set HF 2 Start\n");
			Device->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
			Device->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);
			Device->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_POINT);
			//dprintf("Set HF 2 End\n");
		}
		if(HardwareFilter == 3) {
			Device->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
			Device->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);
			Device->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_LINEAR);
		}

		if(HardwareFilter == 4) {
			float fBias = -4.0;
			Device->SetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, *((LPDWORD) (&fBias)));
			Device->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_ANISOTROPIC);
			Device->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_ANISOTROPIC);
			//m_pd3dDevice->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_ANISOTROPIC);
			Device->SetTextureStageState(0, D3DTSS_MAXANISOTROPY, 4);
		}
		if(HardwareFilter == 5) {
			Device->SetTextureStageState(0, D3DTSS_MAGFILTER,D3DTEXF_QUINCUNX);
			Device->SetTextureStageState(0, D3DTSS_MINFILTER,D3DTEXF_QUINCUNX);
		}
		if(HardwareFilter == 6) {
			Device->SetTextureStageState(0, D3DTSS_MAGFILTER,D3DTEXF_GAUSSIANCUBIC);
			Device->SetTextureStageState(0, D3DTSS_MINFILTER,D3DTEXF_GAUSSIANCUBIC);
		}


		/*
		if(FlickerFilter == 0) {
		Device->SetFlickerFilter(0);
		}
		if(FlickerFilter == 1) {
		Device->SetFlickerFilter(1);
		}
		if(FlickerFilter == 2) {
		Device->SetFlickerFilter(2);
		}
		if(FlickerFilter == 3) {
		Device->SetFlickerFilter(3);
		}
		if(FlickerFilter == 4) {
		Device->SetFlickerFilter(4);
		}
		if(FlickerFilter == 5) {
		Device->SetFlickerFilter(5);
		}

		if(Soften == 1) Device->SetSoftDisplayFilter(true); else Device->SetSoftDisplayFilter(false);
		*/
		/*
		WRITE_LINE(";   0 =  8,000 Hz, 1 = 11,025 Hz, 2 = 22,050 Hz\r\n");
		WRITE_LINE(";   3 = 44,100 Hz, 4 = 16,000 Hz, 5 = 32,000 Hz\r\n");
		WRITE_LINE(";   6 = 48,000 Hz\r\n\r\n");
		*/


		/*SoundInterpolation++; if(SoundInterpolation > 3) SoundInterpolation = 0;
		if(optionSelected == 7) LowPassFilter*/

		//
		//if(SoundInterpolation == 0) {
		//	SoundInterpType = 0;

		//		InitSound();
		//	    AdjustFrequency();

		//}

	}

	extern unsigned char MusicRelVol;
	
	extern void SaveSramData();

/*
				if(optionSelected == 0) { 
					dprintf("Option 0\n");
					HardwareFilter++; 
					if(HardwareFilter > 6) 
						HardwareFilter = 0;  
					setHardwareFilter();
				}
				if(optionSelected == 1) { 
					dprintf("Option 1\n");
					firstVidRender = 1;
					SoftwareFilter++;
					if(SoftwareFilter > 6) 
						SoftwareFilter = 0;  
				}

				if(optionSelected == 2){
					dprintf("Option 2\n");
					FlickerFilter++;
					if(FlickerFilter > 5) 
						FlickerFilter = 0;  
					setFlickerSoft(); 
				}
				if(optionSelected == 3){ 
					dprintf("Option 3\n");
					Soften = (Soften + 1) & 1;  
					setFlickerSoft(); 
				}
				//screen adjust
				if(optionSelected == 4) { 
					dprintf("Option 4\n");
					screenOptions = 0; 
					screenResize = 1; 
					return 0;   
				} 
				if(optionSelected == 5){ 
					dprintf("Option 5\n");
					SoundFrequency++; 
					if(SoundFrequency > 2)
						SoundFrequency = 0;  
					setFrequency();
				}
				if(optionSelected == 6){
					dprintf("Option 6\n");
					SoundInterpolation++;
					if(SoundInterpolation > 2) 
						SoundInterpolation = 0; 
					setSoundInterpolation();
				}
				if(optionSelected == 7) {
					dprintf("Option 7\n");
					LowPassFilter++; 
					if(LowPassFilter > 3) 
						LowPassFilter = 0; 
					setLowPassFilter();
				}
				if(optionSelected == 8) {
					dprintf("Option 8\n");
					SurroundSound = (SurroundSound + 1) & 1;  
					setSurroundSound();
				}
				if(optionSelected == 9) {
					dprintf("Option 9\n");
					DisableSaveStates = (DisableSaveStates + 1) & 1; 
				}

				//resumeMusic(); 
				//screenOptions = 0; 
				//inGame = 0; 
				//optionSelected = 0;
				//return 1;



				if(inGame == 1) {
					if(optionSelected == 10) {
						dprintf("Option 10-A\n");
						LoopMode = 8; 
						lpPrimaryBuffer->Play(0,0,DSBPLAY_LOOPING);
						SoundEnabled = 1; 	
						screenOptions = 0; 
						unsigned char *lock=NULL;
						makeVertexListLinear();
						VertexBufferLinear->Lock(0,sizeof(VertexListLinear),&lock,0); if (lock==NULL) return 1;
						memcpy(lock,VertexListLinear,sizeof(VertexListLinear));
						VertexBufferLinear->Unlock();
						Device->SetTexture(0,TexScreen);
						Device->SetStreamSource(0,VertexBufferLinear,sizeof(CustomVertex));
						Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
						Device->SetTextureStageState( 0, D3DTSS_ADDRESSU, D3DTADDRESS_CLAMP );
						Device->SetTextureStageState( 0, D3DTSS_ADDRESSV, D3DTADDRESS_CLAMP );
						pauseMusic();
						//ZsnesInp.held[8] = 0;
						//ZsnesInp.held[8]=0;
						//ZsnesInp.button[8]=0;
						//keys[pl1Bk] = 0;
						//ZsnesInp.repeat[8]=0;
						//memset(&ZsnesPad,0,sizeof(ZsnesPad));
						return 1;

					} //return to game
					if(optionSelected == 11) {
                        dprintf("Option 11-A\n");
						//drawHack();
						//SaveSramData();
						//asm_call(SaveSramData);
						resumeMusic(); 
						screenOptions = 0; 
						inGame = 0; 
						optionSelected = 0;
						//ZsnesInp.held[8] = 0;
					} //exit game
				}
				else {
					if(optionSelected == 10) { 
						dprintf("Option 10-B\n");
						LD_LAUNCH_DASHBOARD launch;
						memset(&launch,0,sizeof(launch));
						launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
						XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch); 
					}
					if(optionSelected == 11) { 
						dprintf("Option 11-B\n");
						screenOptions = 0;
						//ZsnesInp.held[4]=0;
						//memset(ZsnesInp.axis,  0,sizeof(ZsnesInp.axis));
						//memset(ZsnesInp.button,0,sizeof(ZsnesInp.button));
						return 0;
					}
				}
				*/


	void blankScreen() {
			ClearWin16();
			asm_call(Clear2xSaIBuffer);
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 0;
			hqFilter = 0;
			antienab = 0;
			firstVidRender = 0;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= (unsigned char*) &(SurfBuf[(240-resolutn)*pitch+128]);
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
	}

	int ZsnesMenuUpdate()
	{

		if (g_Gamepads[0].fY2 > 0 && screenResize != 1 && screenResizeP != 1 && screenResizeJ != 1 && screenResizeG != 1 && screenResizeB != 1 && screenResizeA != 1 && screenResizeS != 1 && screenResizePB != 1) {BGVol += 10.0f; setVolume(); }// Up
		if (g_Gamepads[0].fY2 < 0 && screenResize != 1 && screenResizeP != 1 && screenResizeJ != 1 && screenResizeG != 1 && screenResizeB != 1 && screenResizeA != 1 && screenResizeS != 1 && screenResizePB != 1) {BGVol -= 10.0f; setVolume();}


		//}

		//if(ZsnesInp.button[11]>30) { screenResize = 1; return 0; }

		if(screenSoundOptions == 1) {
			checkSoundOptions();
			return 0;
		}

		if(screenGeneralOptions == 1) {
			checkGeneralOptions();
			return 0;
		}

		if(screenGUIOptions == 1) {
			checkGUIOptions();
			return 0;
		}

		if(screenVideoOptions == 1) {
			checkVideoOptions();
			return 0;
		}

		if(screenOptions == 1) {
			//resumeMusic(); 
			//screenOptions = 0; 
			//inGame = 0; 
			//optionSelected = 0;
			//return 1;



			//Change menu options here
			if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP)  {  
				if(DisableMenuSounds == 0)playEffect(0);	
				optionSelected -= 1; 
				if(inGame == 1) {
					if(optionSelected < 0) optionSelected = 10; 
				}
				else {
					if(optionSelected < 6) optionSelected = 9;
				}
			}

			if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN) {  
				if(DisableMenuSounds == 0)playEffect(0);	
				optionSelected += 1; 
				if(inGame == 1) {
					if(optionSelected > 10) optionSelected = 0;
				}
				else {
					if(optionSelected > 9) optionSelected = 6;
				}

			} 


			int r = checkA();
			//writeConfig();
			return r;

			//if(checkA() == 1) return 1;
			//resumeMusic(); 
			//screenOptions = 0; 
			//inGame = 0; 
			//optionSelected = 0;
			//dprintf("Returning 1\n");
		    //return 1;
			
			//return 0;
		}


		//dprintf("Screen Options not set\n");
		//if (ZsnesInp.held[9]==1) { Surround ^= 1; }
		//if (ZsnesInp.held[10]==1) { SoftwareFilter = (SoftwareFilter + 1) & 0x03; }

		if(screenCheatOptions == 1) {
		    processCheatOptions();
			return 0;
		}

		if(saveStateSave == 1) {
		    return processStateOptions();
		}

		if(saveStateLoad == 1) {
		    return processStateOptions();
		}

		if(screenControllerOptions == 1) {
			checkControllerConfig();
			
			return 0;
		}


		if(screenResize == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResize = 0;
				screenResizeP = 0;
				screenResizePB = 0;
				screenResizeJ = 0;
				screenResizeG = 0;
				screenResizeB = 0;
				screenResizeA = 0;
				screenOptionsM = 0;
				screenResizeS = 0;
				screenVideoOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTop+=0.01f;  zBottom+=0.01f; }// Up
			if (g_Gamepads[0].fY1 < 0) {zTop-=0.01f;  zBottom-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeft-=0.01f; zRight-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeft+=0.01f; zRight+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottom+=0.01f; // Up
			if (g_Gamepads[0].fY2 < 0) zBottom-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRight-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRight+=0.01f; // Right
			return 0; 

		}

		if(fontResizeR == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeR = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopBR-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopBR+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftBR-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftBR+=1;  }// Right
			return 0; 

		}

		if(fontResizeV == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeV = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopV-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopV+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftV-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftV+=1;  }// Right
			return 0; 

		}

		if(fontResizeS == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeS = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopSM-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopSM+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftSM-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftSM+=1;  }// Right
			return 0; 

		}

		if(fontResizeG == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeG = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopGM-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopGM+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftGM-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftGM+=1;  }// Right
			return 0; 

		}

		if(fontResizeM == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeM = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopMM-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopMM+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftMM-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftMM+=1;  }// Right
			return 0; 

		}

		if(fontResizeF == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				fontResizeF = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopBF-=1;   }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopBF+=1;   } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftBF-=1; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftBF+=1;  }// Right
			return 0; 

		}

		if(screenResizeP == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeP = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopP+=0.01f;  zBottomP+=0.01f; }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopP-=0.01f;  zBottomP-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftP-=0.01f; zRightP-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftP+=0.01f; zRightP+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomP+=0.01f; // Up
			if (g_Gamepads[0].fY2 < 0) zBottomP-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightP-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightP+=0.01f; // Right
			return 0; 

		}

		if(screenResizePB == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizePB = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopPB+=0.01f;  zBottomPB+=0.01f; }// Up
			if (g_Gamepads[0].fY1 < 0) {zTopPB-=0.01f;  zBottomPB-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftPB-=0.01f; zRightPB-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftPB+=0.01f; zRightPB+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomPB+=0.01f; // Up
			if (g_Gamepads[0].fY2 < 0) zBottomPB-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightPB-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightPB+=0.01f; // Right
			return 0; 

		}

		if(screenResizeJ == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeJ = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopJ+=0.01f;  zBottomJ+=0.01f; }// UJ
			if (g_Gamepads[0].fY1 < 0) {zTopJ-=0.01f;  zBottomJ-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftJ-=0.01f; zRightJ-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftJ+=0.01f; zRightJ+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomJ+=0.01f; // UJ
			if (g_Gamepads[0].fY2 < 0) zBottomJ-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightJ-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightJ+=0.01f; // Right
			return 0; 

		}

		if(screenResizeG == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeG = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopG+=0.01f;  zBottomG+=0.01f; }// UJ
			if (g_Gamepads[0].fY1 < 0) {zTopG-=0.01f;  zBottomG-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftG-=0.01f; zRightG-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftG+=0.01f; zRightG+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomG+=0.01f; // UJ
			if (g_Gamepads[0].fY2 < 0) zBottomG-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightG-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightG+=0.01f; // Right
			return 0; 

		}

		if(screenResizeB == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeB = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopB+=0.01f;  zBottomB+=0.01f; }// UJ
			if (g_Gamepads[0].fY1 < 0) {zTopB-=0.01f;  zBottomB-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftB-=0.01f; zRightB-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftB+=0.01f; zRightB+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomB+=0.01f; // UJ
			if (g_Gamepads[0].fY2 < 0) zBottomB-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightB-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightB+=0.01f; // Right
			return 0; 

		}

		if(screenResizeA == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeA = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopA+=0.01f;  zBottomA+=0.01f; }// UJ
			if (g_Gamepads[0].fY1 < 0) {zTopA-=0.01f;  zBottomA-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftA-=0.01f; zRightA-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftA+=0.01f; zRightA+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomA+=0.01f; // UJ
			if (g_Gamepads[0].fY2 < 0) zBottomA-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightA-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightA+=0.01f; // Right

			zLeftA2 = zLeftA;
			zRightA2 = zRightA;
			zTopA2 = zTopA;
			zBottomA2 = zBottomA;
			return 0; 

		}

		if(screenOptionsM == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_A) {
				if(DisableMenuSounds == 0) playEffect(2);
				
				
				if(optionSelectedM == 0 ) { screenOptionsM = 0; screenOptions = 0; screenGUIOptions = 0;}
				if(optionSelectedM == 1 ) { screenOptionsM = 0; screenOptions = 1; screenGUIOptions = 0;}
				if(optionSelectedM == 2 ) { guiOptionSelected = 0; screenOptionsM = 0; screenGUIOptions = 1; gFont = 1;screenOptions = 0;}
				if(optionSelectedM == 3 ) { guiOptionSelected = 0; screenOptionsM = 0; screenGUIOptions = 1; gFont = 0;screenOptions = 0;}
				if(optionSelectedM == 4 ) {
					writeConfig();
					LD_LAUNCH_DASHBOARD launch;
					memset(&launch,0,sizeof(launch));
					launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
					XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch); 
				}
				zA = 0;
				LoopMode = 2;
				return 0;
			}

			if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP)  {  
				if(DisableMenuSounds == 0)playEffect(0);	
				optionSelectedM -= 1; 
				if(optionSelectedM < 0) optionSelectedM = 4;
			}

			if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN) {  
				if(DisableMenuSounds == 0)playEffect(0);	
				optionSelectedM += 1; 
				if(optionSelectedM > 4) optionSelectedM = 0;

			} 
			return 0;
		}
		

		if(screenResizeS == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				if(DisableMenuSounds == 0) playEffect(1);
				screenResizeS = 0; screenGUIOptions = 1;
				LoopMode = 2;
				writeConfig();
				//restoreResolution();
				return 0;
			}

			if (g_Gamepads[0].fY1 > 0) {zTopS+=0.01f;  zBottomS+=0.01f; }// UJ
			if (g_Gamepads[0].fY1 < 0) {zTopS-=0.01f;  zBottomS-=0.01f; } // Down
			if (g_Gamepads[0].fX1 < 0) {zLeftS-=0.01f; zRightS-=0.01f; } // Left
			if (g_Gamepads[0].fX1 > 0) {zLeftS+=0.01f; zRightS+=0.01f; }// Right

			if (g_Gamepads[0].fY2 > 0) zBottomS+=0.01f; // UJ
			if (g_Gamepads[0].fY2 < 0) zBottomS-=0.01f; // Down
			if (g_Gamepads[0].fX2 < 0) zRightS-=0.01f; // Left
			if (g_Gamepads[0].fX2 > 0) zRightS+=0.01f; // Right
			return 0; 

		}
		//if(g_Gamepads[0].Event == XBGAMEPAD_Y) {
		//	if(DisableMenuSounds == 0) playEffect(2); screenOptions = 1; optionSelected = 6;
		//	return 0;
		//} //B to access options

		if(g_Gamepads[0].Event == XBGAMEPAD_B) {
			if(DisableMenuSounds == 0) playEffect(1); 
			screenOptionsM = 1;
			return 0;
		} //B to access options


		if(g_Gamepads[0].Event == XBGAMEPAD_Y) { 
			if(root == 1)
				return 0;
			
			
			selected = 1;
			FileMenu.choiceFocus = 0;
			y2 = 0;
			lastChoice = 80;
			dprintf("B: currentpath: %s\n", FileMenu.currentPath);
			FileMenu.scan();
			return 0;
		}

		if(LoopMode != 8) {
			romMove = 0;
			int	delta=0;
			if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP) {  if(DisableMenuSounds == 0) playEffect(0);	romMove = 1; delta-=0x100; menuChanged=true;	fastScroll = false;	buttonPressed =	0; } 
			if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN) {  if(DisableMenuSounds == 0)playEffect(0);	romMove = 1; delta+=0x100; menuChanged=true;	fastScroll = false;	  buttonPressed	= 1;  }  

			//if((selected < (gamesFound)-15) && ((gamesFound) > 15)) {
			//	if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_RIGHT) { 	selected += 17;  delta+=(17 * 0x100); 	fastScroll = false;	  buttonPressed	= 1;  } 
			//}

			//if((selected < (gamesFound)-15) && ((gamesFound) > 15)) {
			//	if (g_Gamepads[0].Event == XBGAMEPAD_DPAD_LEFT) {   selected -= 17;  delta-=(17 * 0x100); 	fastScroll = false;	buttonPressed =	0; } 
			//}

            a =	false;
			fastScroll = false;
			if (g_Gamepads[0].fY1 > 0) {  a =	true;  b = true;  menuChanged=true;	fastScroll = true; delta-=(0x100); } 
			if (g_Gamepads[0].fY1 < 0) {  a = true;  b	= true;	menuChanged=true; fastScroll = true; delta+=(0x100);  }  

			if(a == false) {
				if (g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {   a = true;  b	= true;	menuChanged=true; fastScroll = true; delta-=0x100; }
				if (g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {	a =	true;  b = true;  menuChanged=true;	fastScroll = true; delta+=0x100;    }
			}

			if (a == false)	{
				if (b == true) {
					b =	false;
					menuChanged	= true;
					romMove = 1;
				}
			}
			if (delta) FileMenu.scroll(delta);
			if ((g_Gamepads[0].Event == XBGAMEPAD_A) && screenResize != 1
				&& screenResizeP != 1 && screenResizePB != 1 && screenResizeJ != 1 && screenResizeG != 1 && screenResizeB != 1 && screenResizeA != 1 && screenOptionsM != 1 && screenResizeS != 1 && screenOptions != 1 && screenControllerOptions != 1 && screenCheatOptions != 1) // A, X or Start
			{
                //if(DisableMenuSounds == 0) playEffect(2); 
				if(checkSelection() == -1) {  return 0; }
				//startHDMode();
				firstVidRender = 1;
				//blankScreen();
				inGame = 1;
				SoundEnabled = 1;
				GUIOn2 = 0;
				LoopMode = 8;
				pauseMusic();




				unsigned char *lock=NULL;
				makeVertexListLinear();
				VertexBufferLinear->Lock(0,sizeof(VertexListLinear),&lock,0); if (lock==NULL) return 1;
				memcpy(lock,VertexListLinear,sizeof(VertexListLinear));
				VertexBufferLinear->Unlock();
				Device->SetTexture(0,TexScreen);
				Device->SetStreamSource(0,VertexBufferLinear,sizeof(CustomVertex));
				Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
				Device->SetTextureStageState( 0, D3DTSS_ADDRESSU, D3DTADDRESS_CLAMP );
				Device->SetTextureStageState( 0, D3DTSS_ADDRESSV, D3DTADDRESS_CLAMP );


				pauseMusic();
				FileMenu.getFilePath(RomName);

				for(int i = 0; i < 512; i++) fname[i] = '\0';
				for(int i = 0; i < 512; i++) fnames[i] = '\0';
				for(int i = 0; i < 512; i++) fnamest[i] = '\0';
			
				initCheatCodes();
				loadCheat();


				fname[0] = RomName[0];
				for(int i = 1; i < 1024; i++) {
					if(RomName[i-1] == '\0') {
						fname[i] = RomName[i-1];
						break;
					}
					else {
						fname[i] = RomName[i-1];
					}
				}

				dprintf("ZSNES Going to Load: %s\n", fname);





				fnames[0] = savePartition;
				fnames[1] = savePartition;
				fnames[2] = ':';
				fnames[3] = '\\';
				fnames[4] = 'Z';
				fnames[5] = 's';
				fnames[6] = 'n';
				fnames[7] = 'e';
				fnames[8] = 'x';
				fnames[9] = 'B';
				fnames[10] = 'o';
				fnames[11] = 'x';

				fnames[12] = '\\';
				fnames[13] = 's';
				fnames[14] = 'r';
				fnames[15] = 'a';
				fnames[16] = 'm';
				fnames[17] = '\\';

				//D:\Games\Game.zip
				//D:Game.zip
				int lastB = 0;
				int i0 = 0;
				for(i0 = 0; i0 < 260; i0++) {
					if(RomName[i0] == '\0') {
						if(lastB == 0) {
							for(int q = 18; q < 260; q++) {
								fnames[q] = RomName[(q - 18) + 2];

								if(RomName[(q - 18) + 2] == '\0') {
									fnames[q] = '\0';
									fnames[q-1] = 'm';
									fnames[q-2] = 'r';
									fnames[q-3] = 's';
									break;
								}
							}
							break;
						}
						else {
							for(int q = 18; q < 260; q++) {
								fnames[q] = RomName[lastB + 1 + (q - 18)];

								//D:\Games\a.zip
								if(RomName[lastB + 1 + (q - 18)] == '\0') {
									fnames[q] = '\0';
									fnames[q-1] = 'm';
									fnames[q-2] = 'r';
									fnames[q-3] = 's';
									//dprintf("fnames First: %s\n", fnames);
									break;
								}
							}
							break;
						}
					}

					if(RomName[i0] == '\\') lastB = i0;

				}

				//dprintf("fnames After: %s\n", fnames);





				//fnames[i2] = 'm';
				//fnames[i2-1] = 'r';
				//fnames[i2-2] = 's';


				dprintf("Zsnes fnames: %s\n", fnames);






				fnamest[0] = savePartition;
				fnamest[1] = savePartition;
				fnamest[2] = ':';
				fnamest[3] = '\\';
				fnamest[4] = 'Z';
				fnamest[5] = 's';
				fnamest[6] = 'n';
				fnamest[7] = 'e';
				fnamest[8] = 'x';
				fnamest[9] = 'B';
				fnamest[10] = 'o';
				fnamest[11] = 'x';

				fnamest[12] = '\\';
				fnamest[13] = 's';
				fnamest[14] = 'a';
				fnamest[15] = 'v';
				fnamest[16] = 'e';
				fnamest[17] = '\\';

				//D:\Games\Game.zip
				//D:Game.zip
				lastB = 0;
				i0 = 0;
				for(i0 = 0; i0 < 260; i0++) {
					if(RomName[i0] == '\0') {
						if(lastB == 0) {
							for(int q = 18; q < 260; q++) {
								fnamest[q] = RomName[(q - 18) + 2];

								if(RomName[(q - 18) + 2] == '\0') {
									fnamest[q] = '\0';
									fnamest[q-1] = 't';
									fnamest[q-2] = 's';
									fnamest[q-3] = 'z';
									break;
								}
							}
							break;
						}
						else {
							for(int q = 18; q < 260; q++) {
								fnamest[q] = RomName[lastB + 1 + (q - 18)];

								//D:\Games\a.zip
								if(RomName[lastB + 1 + (q - 18)] == '\0') {
									fnamest[q] = '\0';
									fnamest[q-1] = 't';
									fnamest[q-2] = 's';
									fnamest[q-3] = 'z';
									//dprintf("fnamest First: %s\n", fnamest);
									break;
								}
							}
							break;
						}
					}

					if(RomName[i0] == '\\') lastB = i0;

				}

				dprintf("fnamest After: %s\n", fnamest);



				TexScreen->LockRect( 0, &lockScreen, 0, 0L );
				SurfBuf = (BYTE*)lockScreen.pBits;
				pitch = lockScreen.Pitch;
				
				for(int i = 0; i < 480; i++) {
					for(int j = 0; j < 640 * 2; j++) {
						SurfBuf[(i * pitch) + j] = 0;
					}
				}
				TexScreen->UnlockRect(0);
				if(lpPrimaryBuffer)
					lpPrimaryBuffer->Release();
				InitSound();
				optionSelected = 0;
				En2xSaI = 0;
				antienab = 0;
				hqFilter = 0;
			    createSaveStateDirectories();
				SaveSlot(0);
				//freeTexture();
				clearvidsound();
		 		GUIDoReset();
				asm_call(init);
			}
		}
		return 0;
	}



	


int aCount = 60;
int bCount = 60;

int rumble = 120;
void WinUpdateDevices()
	{   

		
		//per2exec = Bper2exec;
		//cfgper2exec = Bcfgper2exec;
		//Setper2exec();
		//SnowOn = 1;
		//SPCDisable = SPCEmulationEnabled ^ 1;
		keys = (unsigned char *)&pressed;

		
		if(LoopMode == 2) {
			while(LoopMode == 2) {
				//dprintf("(A");
				updateSound();
				//dprintf("B");
				updateEffect();
				//dprintf("C");
				Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
				//dprintf("D");
				if(ZsnesMenuUpdate() == 1) return;
				//dprintf("E");
				DirectScreen();
				//dprintf("F");
				if (screenResize != 1 && screenOptions != 1 
					&& screenVideoOptions != 1
					&& screenResizeP != 1
					&& screenResizePB != 1
					&& screenResizeJ != 1
					&& screenResizeG != 1
					&& screenResizeB != 1
					&& screenResizeA != 1
					&& screenOptionsM != 1
					&& screenResizeS != 1
					&& screenSoundOptions != 1
					&& screenLightGunOptions != 1
					&& screenGeneralOptions != 1
					&& screenGUIOptions != 1
					&& saveStateLoad != 1
					&& saveStateSave != 1
					&& screenCheatOptions != 1
					&& fontResizeR != 1
					&& fontResizeF != 1
					&& fontResizeV != 1
					&& fontResizeS != 1
					&& fontResizeG != 1
					&& fontResizeM != 1
					&& screenControllerOptions != 1) MenuRender();
				//dprintf("G");
				//showMemory();
				Device->Present(NULL,NULL,NULL,NULL); 
				//dprintf("H");
				readInput();
				//dprintf("I");
				//Sleep(1);
				//dprintf("J)  ");
			}
			return;
		}
		
		if(romtype == 2) {
			applyCheatCodesHiROM();
		}

		if(romtype == 1) {
			applyCheatCodesLoROM();
		}
		
		
		
		
		
		
		
		readInput();
		

		
		if(aCount < 60) {
			aCount++;
		}
		else {
			if(controllers[p1].button_B != -1) {
				if(tButtons[0].turboB == 1) {
					if(controllers[p1].button_B == XINPUT_GAMEPAD_BACK ||
					controllers[p1].button_B == XINPUT_GAMEPAD_START ||
					controllers[p1].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p1].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[p1].wButtons & (controllers[p1].button_B & 0xFFFF)) keys[pl1Btk] = 1;     else keys[pl1Btk] = 0; 
					else
					if (g_Gamepads[p1].bAnalogButtons[controllers[p1].button_B]) keys[pl1Btk] = 1;     else keys[pl1Btk] = 0; 
				}
				else {
					if(controllers[p1].button_B == XINPUT_GAMEPAD_BACK ||
					controllers[p1].button_B == XINPUT_GAMEPAD_START ||
					controllers[p1].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p1].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[p1].wButtons & (controllers[p1].button_B & 0xFFFF)) keys[pl1Bk] = 1;     else keys[pl1Bk] = 0; 
					else
					if (g_Gamepads[p1].bAnalogButtons[controllers[p1].button_B]) keys[pl1Bk] = 1;     else keys[pl1Bk] = 0; 
				}
			}
		}
		
		if(controllers[p1].button_Y != -1) {
			if(tButtons[0].turboY == 1) {
				if(controllers[p1].button_Y == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_Y == XINPUT_GAMEPAD_START ||
				controllers[p1].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_Y & 0xFFFF))  keys[pl1Ytk] = 1;     else keys[pl1Ytk] = 0; 
				else
				if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Y]) keys[pl1Ytk] = 1;     else keys[pl1Ytk] = 0; 
			}
			else {
				if(controllers[p1].button_Y == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_Y == XINPUT_GAMEPAD_START ||
				controllers[p1].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_Y & 0xFFFF))  keys[pl1Yk] = 1;     else keys[pl1Yk] = 0; 
				else
				if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Y]) keys[pl1Yk] = 1;     else keys[pl1Yk] = 0; 
			}
		}
		

		if(controllers[p1].button_Start != -1) {
			if(controllers[p1].button_Start == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_Start == XINPUT_GAMEPAD_START ||
				controllers[p1].button_Start == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_Start == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_Start & 0xFFFF))  keys[pl1startk] = 1;     else keys[pl1startk] = 0; 
			else
				if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Start]) keys[pl1startk] = 1;     else keys[pl1startk] = 0; 
		}

		if(controllers[p1].button_Right != -1) {
			if(tButtons[0].turboR == 1) {
				if(controllers[p1].button_Right == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_Right == XINPUT_GAMEPAD_START ||
				controllers[p1].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_Right & 0xFFFF))  keys[pl1Rtk] = 1;     else keys[pl1Rtk] = 0; 
				else
					if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Right]) {
						dprintf("Turbo R A\n");
						keys[pl1Rtk] = 1;     
					}
					else {
						dprintf("Turbo R B\n");
						keys[pl1Rtk] = 0;
					}
			}
			else {
				if(controllers[p1].button_Right == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_Right == XINPUT_GAMEPAD_START ||
				controllers[p1].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_Right & 0xFFFF))  keys[pl1Rk] = 1;     else keys[pl1Rk] = 0; 
				else
				if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Right]) keys[pl1Rk] = 1;     else keys[pl1Rk] = 0; 
			}
		}

		if(controllers[p1].button_Left != -1) {
			if(tButtons[0].turboL == 1) {
				if(controllers[p1].button_Left == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_Left == XINPUT_GAMEPAD_START ||
				controllers[p1].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_Left & 0xFFFF))  keys[pl1Ltk] = 1;     else keys[pl1Ltk] = 0; 
				else
				if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Left]) keys[pl1Ltk] = 1;     else keys[pl1Ltk] = 0; 
			}
			else {
				if(controllers[p1].button_Left == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_Left == XINPUT_GAMEPAD_START ||
				controllers[p1].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_Left & 0xFFFF))  keys[pl1Lk] = 1;     else keys[pl1Lk] = 0; 
				else
				if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Left]) keys[pl1Lk] = 1;     else keys[pl1Lk] = 0; 
			}
		}
		
		if(controllers[p1].button_X != -1) {
			if(tButtons[0].turboX == 1) {
				if(controllers[p1].button_X == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_X == XINPUT_GAMEPAD_START ||
				controllers[p1].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_X & 0xFFFF))  keys[pl1Xtk] = 1;     else keys[pl1Xtk] = 0; 
				else
				if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_X]) keys[pl1Xtk] = 1;     else keys[pl1Xtk] = 0; 
			}
			else {
				if(controllers[p1].button_X == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_X == XINPUT_GAMEPAD_START ||
				controllers[p1].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_X & 0xFFFF))  keys[pl1Xk] = 1;     else keys[pl1Xk] = 0; 
				else
				if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_X]) keys[pl1Xk] = 1;     else keys[pl1Xk] = 0; 
			}
		}
			
			
		

		if(bCount < 60) {
			bCount++;
		}
		else {
			if(tButtons[0].turboA == 1) {
				if(controllers[p1].button_A != -1) {
				if(controllers[p1].button_A == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_A == XINPUT_GAMEPAD_START ||
				controllers[p1].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_A & 0xFFFF))  keys[pl1Atk] = 1;     else keys[pl1Atk] = 0; 
				else
				if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_A]) keys[pl1Atk] = 1;     else keys[pl1Atk] = 0; 
				}
			}
			else {
				if(controllers[p1].button_A != -1) {
					if(controllers[p1].button_A == XINPUT_GAMEPAD_BACK ||
						controllers[p1].button_A == XINPUT_GAMEPAD_START ||
						controllers[p1].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p1].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[0].wButtons & (controllers[p1].button_A & 0xFFFF))  keys[pl1Ak] = 1;     else keys[pl1Ak] = 0; 
					else
						if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_A]) keys[pl1Ak] = 1;     else keys[pl1Ak] = 0; 
				}
			}
		}

		if(controllers[p1].button_Select != -1) {
			if(controllers[p1].button_Select == XINPUT_GAMEPAD_BACK ||
				controllers[p1].button_Select == XINPUT_GAMEPAD_START ||
				controllers[p1].button_Select == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p1].button_Select == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[p1].button_Select & 0xFFFF))  keys[pl1selk] = 1;     else keys[pl1selk] = 0; 
			else
				if (g_Gamepads[0].bAnalogButtons[controllers[p1].button_Select]) keys[pl1selk] = 1;     else keys[pl1selk] = 0; 
		}

		if (g_Gamepads[0].fY1 > 0 || g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP)            keys[pl1upk] = 1;    else keys[pl1upk] = 0; 
		if (g_Gamepads[0].fY1 < 0 || g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_DOWN)          keys[pl1downk] = 1;  else keys[pl1downk] = 0;
		if (g_Gamepads[0].fX1 < 0 || g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_LEFT)          keys[pl1leftk] = 1;  else keys[pl1leftk] = 0;
		if (g_Gamepads[0].fX1 > 0 || g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT)         keys[pl1rightk] = 1; else keys[pl1rightk] = 0;
		
	

		





		//Player 2---------------------------------------------------------------------------------------------
		if(controllers[p2].button_B != -1) {
			if(tButtons[1].turboB == 1) {
				if(controllers[p2].button_B == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_B == XINPUT_GAMEPAD_START ||
					controllers[p2].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_B & 0xFFFF)) keys[pl2Btk] = 1;     else keys[pl2Btk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_B]) keys[pl2Btk] = 1;     else keys[pl2Btk] = 0; 
			}
			else {
				if(controllers[p2].button_B == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_B == XINPUT_GAMEPAD_START ||
					controllers[p2].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_B & 0xFFFF)) keys[pl2Bk] = 1;     else keys[pl2Bk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_B]) keys[pl2Bk] = 1;     else keys[pl2Bk] = 0;
			}
		}
		
		if(controllers[p2].button_Y != -1) {

			if(tButtons[1].turboY == 1) {
				if(controllers[p2].button_Y == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_Y == XINPUT_GAMEPAD_START ||
					controllers[p2].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_Y & 0xFFFF))  keys[pl2Ytk] = 1;     else keys[pl2Ytk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Y]) keys[pl2Ytk] = 1;     else keys[pl2Ytk] = 0; 
			}
			else {
				if(controllers[p2].button_Y == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_Y == XINPUT_GAMEPAD_START ||
					controllers[p2].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_Y & 0xFFFF))  keys[pl2Yk] = 1;     else keys[pl2Yk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Y]) keys[pl2Yk] = 1;     else keys[pl2Yk] = 0; 

			}
		}
		

		if(controllers[p2].button_Start != -1) {
			if(controllers[p2].button_Start == XINPUT_GAMEPAD_BACK ||
				controllers[p2].button_Start == XINPUT_GAMEPAD_START ||
				controllers[p2].button_Start == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p2].button_Start == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[1].wButtons & (controllers[p2].button_Start & 0xFFFF))  keys[pl2startk] = 1;     else keys[pl2startk] = 0; 
			else
				if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Start]) keys[pl2startk] = 1;     else keys[pl2startk] = 0; 
		}

		if(controllers[p2].button_Right != -1) {
			if(tButtons[1].turboR == 1) {
				if(controllers[p2].button_Right == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_Right == XINPUT_GAMEPAD_START ||
					controllers[p2].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_Right & 0xFFFF))  keys[pl2Rtk] = 1;     else keys[pl2Rtk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Right]) keys[pl2Rtk] = 1;     else keys[pl2Rtk] = 0; 
			}
			else {
				if(controllers[p2].button_Right == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_Right == XINPUT_GAMEPAD_START ||
					controllers[p2].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_Right & 0xFFFF))  keys[pl2Rk] = 1;     else keys[pl2Rk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Right]) keys[pl2Rk] = 1;     else keys[pl2Rk] = 0; 
			}
		}
		

		if(controllers[p2].button_Left != -1) {
			if(tButtons[1].turboL == 1) {
				if(controllers[p2].button_Left == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_Left == XINPUT_GAMEPAD_START ||
					controllers[p2].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_Left & 0xFFFF))  keys[pl2Ltk] = 1;     else keys[pl2Ltk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Left]) keys[pl2Ltk] = 1;     else keys[pl2Ltk] = 0; 
			}
			else {
				if(controllers[p2].button_Left == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_Left == XINPUT_GAMEPAD_START ||
					controllers[p2].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_Left & 0xFFFF))  keys[pl2Lk] = 1;     else keys[pl2Lk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Left]) keys[pl2Lk] = 1;     else keys[pl2Lk] = 0; 
			}
		}
		
		if(controllers[p2].button_X != -1) {
			if(tButtons[1].turboX == 1) {
				if(controllers[p2].button_X == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_X == XINPUT_GAMEPAD_START ||
					controllers[p2].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_X & 0xFFFF))  keys[pl2Xtk] = 1;     else keys[pl2Xtk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_X]) keys[pl2Xtk] = 1;     else keys[pl2Xtk] = 0; 
			}
			else {
				if(controllers[p2].button_X == XINPUT_GAMEPAD_BACK ||
					controllers[p2].button_X == XINPUT_GAMEPAD_START ||
					controllers[p2].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p2].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[1].wButtons & (controllers[p2].button_X & 0xFFFF))  keys[pl2Xk] = 1;     else keys[pl2Xk] = 0; 
				else
					if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_X]) keys[pl2Xk] = 1;     else keys[pl2Xk] = 0; 
			}
		}

		if(controllers[p2].button_A != -1) {
			if(tButtons[1].turboA == 1) {
			if(controllers[p2].button_A == XINPUT_GAMEPAD_BACK ||
				controllers[p2].button_A == XINPUT_GAMEPAD_START ||
				controllers[p2].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p2].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[1].wButtons & (controllers[p2].button_A & 0xFFFF))  keys[pl2Atk] = 1;     else keys[pl2Atk] = 0; 
			else
				if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_A]) keys[pl2Atk] = 1;     else keys[pl2Atk] = 0; 
			}
			else {
				if(controllers[p2].button_A == XINPUT_GAMEPAD_BACK ||
				controllers[p2].button_A == XINPUT_GAMEPAD_START ||
				controllers[p2].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p2].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[1].wButtons & (controllers[p2].button_A & 0xFFFF))  keys[pl2Ak] = 1;     else keys[pl2Ak] = 0; 
			else
				if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_A]) keys[pl2Ak] = 1;     else keys[pl2Ak] = 0;
			}
		}

		if(controllers[p2].button_Select != -1) {
			if(controllers[p2].button_Select == XINPUT_GAMEPAD_BACK ||
				controllers[p2].button_Select == XINPUT_GAMEPAD_START ||
				controllers[p2].button_Select == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[p2].button_Select == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[1].wButtons & (controllers[p2].button_Select & 0xFFFF))  keys[pl2selk] = 1;     else keys[pl2selk] = 0; 
			else
				if (g_Gamepads[1].bAnalogButtons[controllers[p2].button_Select]) keys[pl2selk] = 1;     else keys[pl2selk] = 0; 
		}

		if (g_Gamepads[1].fY1 > 0 || g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_UP)            keys[pl2upk] = 1;    else keys[pl2upk] = 0; 
		if (g_Gamepads[1].fY1 < 0 || g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_DOWN)          keys[pl2downk] = 1;  else keys[pl2downk] = 0;
		if (g_Gamepads[1].fX1 < 0 || g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_LEFT)          keys[pl2leftk] = 1;  else keys[pl2leftk] = 0;
		if (g_Gamepads[1].fX1 > 0 || g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT)         keys[pl2rightk] = 1; else keys[pl2rightk] = 0;


		//dprintf("Disable 34: %d\n", Disable34);
		if(Disable34 == 1) {
			//dprintf("Testing P3 and P4: %d, %d\n", p3, p4);
			
			//Player 3---------------------------------------------------------------------------------------------
			if(controllers[p3].button_B != -1) {
				if(tButtons[2].turboB == 1) {
					if(controllers[p3].button_B == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_B == XINPUT_GAMEPAD_START ||
						controllers[p3].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_B & 0xFFFF)) keys[pl3Btk] = 1;     else keys[pl3Btk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_B]) keys[pl3Btk] = 1;     else keys[pl3Btk] = 0; 
				}
				else {
					if(controllers[p3].button_B == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_B == XINPUT_GAMEPAD_START ||
						controllers[p3].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_B & 0xFFFF)) keys[pl3Bk] = 1;     else keys[pl3Bk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_B]) keys[pl3Bk] = 1;     else keys[pl3Bk] = 0;
				}
			}

			if(controllers[p3].button_Y != -1) {

				if(tButtons[2].turboY == 1) {
					if(controllers[p3].button_Y == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_Y == XINPUT_GAMEPAD_START ||
						controllers[p3].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_Y & 0xFFFF))  keys[pl3Ytk] = 1;     else keys[pl3Ytk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Y]) keys[pl3Ytk] = 1;     else keys[pl3Ytk] = 0; 
				}
				else {
					if(controllers[p3].button_Y == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_Y == XINPUT_GAMEPAD_START ||
						controllers[p3].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_Y & 0xFFFF))  keys[pl3Yk] = 1;     else keys[pl3Yk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Y]) keys[pl3Yk] = 1;     else keys[pl3Yk] = 0; 

				}
			}


			if(controllers[p3].button_Start != -1) {
				if(controllers[p3].button_Start == XINPUT_GAMEPAD_BACK ||
					controllers[p3].button_Start == XINPUT_GAMEPAD_START ||
					controllers[p3].button_Start == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p3].button_Start == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[2].wButtons & (controllers[p3].button_Start & 0xFFFF))  keys[pl3startk] = 1;     else keys[pl3startk] = 0; 
				else
					if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Start]) keys[pl3startk] = 1;     else keys[pl3startk] = 0; 
			}

			if(controllers[p3].button_Right != -1) {
				if(tButtons[2].turboR == 1) {
					if(controllers[p3].button_Right == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_Right == XINPUT_GAMEPAD_START ||
						controllers[p3].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_Right & 0xFFFF))  keys[pl3Rtk] = 1;     else keys[pl3Rtk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Right]) keys[pl3Rtk] = 1;     else keys[pl3Rtk] = 0; 
				}
				else {
					if(controllers[p3].button_Right == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_Right == XINPUT_GAMEPAD_START ||
						controllers[p3].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_Right & 0xFFFF))  keys[pl3Rk] = 1;     else keys[pl3Rk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Right]) keys[pl3Rk] = 1;     else keys[pl3Rk] = 0; 
				}
			}


			if(controllers[p3].button_Left != -1) {
				if(tButtons[2].turboL == 1) {
					if(controllers[p3].button_Left == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_Left == XINPUT_GAMEPAD_START ||
						controllers[p3].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_Left & 0xFFFF))  keys[pl3Ltk] = 1;     else keys[pl3Ltk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Left]) keys[pl3Ltk] = 1;     else keys[pl3Ltk] = 0; 
				}
				else {
					if(controllers[p3].button_Left == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_Left == XINPUT_GAMEPAD_START ||
						controllers[p3].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_Left & 0xFFFF))  keys[pl3Lk] = 1;     else keys[pl3Lk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Left]) keys[pl3Lk] = 1;     else keys[pl3Lk] = 0; 
				}
			}

			if(controllers[p3].button_X != -1) {
				if(tButtons[2].turboX == 1) {
					if(controllers[p3].button_X == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_X == XINPUT_GAMEPAD_START ||
						controllers[p3].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_X & 0xFFFF))  keys[pl3Xtk] = 1;     else keys[pl3Xtk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_X]) keys[pl3Xtk] = 1;     else keys[pl3Xtk] = 0; 
				}
				else {
					if(controllers[p3].button_X == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_X == XINPUT_GAMEPAD_START ||
						controllers[p3].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_X & 0xFFFF))  keys[pl3Xk] = 1;     else keys[pl3Xk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_X]) keys[pl3Xk] = 1;     else keys[pl3Xk] = 0; 
				}
			}

			if(controllers[p3].button_A != -1) {
				if(tButtons[2].turboA == 1) {
					if(controllers[p3].button_A == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_A == XINPUT_GAMEPAD_START ||
						controllers[p3].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_A & 0xFFFF))  keys[pl3Atk] = 1;     else keys[pl3Atk] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_A]) keys[pl3Atk] = 1;     else keys[pl3Atk] = 0; 
				}
				else {
					if(controllers[p3].button_A == XINPUT_GAMEPAD_BACK ||
						controllers[p3].button_A == XINPUT_GAMEPAD_START ||
						controllers[p3].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p3].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[2].wButtons & (controllers[p3].button_A & 0xFFFF))  keys[pl3Ak] = 1;     else keys[pl3Ak] = 0; 
					else
						if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_A]) keys[pl3Ak] = 1;     else keys[pl3Ak] = 0;
				}
			}

			if(controllers[p3].button_Select != -1) {
				if(controllers[p3].button_Select == XINPUT_GAMEPAD_BACK ||
					controllers[p3].button_Select == XINPUT_GAMEPAD_START ||
					controllers[p3].button_Select == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p3].button_Select == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[2].wButtons & (controllers[p3].button_Select & 0xFFFF))  keys[pl3selk] = 1;     else keys[pl3selk] = 0; 
				else
					if (g_Gamepads[2].bAnalogButtons[controllers[p3].button_Select]) keys[pl3selk] = 1;     else keys[pl3selk] = 0; 
			}

			if (g_Gamepads[2].fY1 > 0 || g_Gamepads[2].wButtons & XINPUT_GAMEPAD_DPAD_UP)            keys[pl3upk] = 1;    else keys[pl3upk] = 0; 
			if (g_Gamepads[2].fY1 < 0 || g_Gamepads[2].wButtons & XINPUT_GAMEPAD_DPAD_DOWN)          keys[pl3downk] = 1;  else keys[pl3downk] = 0;
			if (g_Gamepads[2].fX1 < 0 || g_Gamepads[2].wButtons & XINPUT_GAMEPAD_DPAD_LEFT)          keys[pl3leftk] = 1;  else keys[pl3leftk] = 0;
			if (g_Gamepads[2].fX1 > 0 || g_Gamepads[2].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT)         keys[pl3rightk] = 1; else keys[pl3rightk] = 0;

			



			//Player 4---------------------------------------------------------------------------------------------
			if(controllers[p4].button_B != -1) {
				if(tButtons[3].turboB == 1) {
					if(controllers[p4].button_B == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_B == XINPUT_GAMEPAD_START ||
						controllers[p4].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_B & 0xFFFF)) keys[pl4Btk] = 1;     else keys[pl4Btk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_B]) keys[pl4Btk] = 1;     else keys[pl4Btk] = 0; 
				}
				else {
					if(controllers[p4].button_B == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_B == XINPUT_GAMEPAD_START ||
						controllers[p4].button_B == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_B == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_B & 0xFFFF)) keys[pl4Bk] = 1;     else keys[pl4Bk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_B]) keys[pl4Bk] = 1;     else keys[pl4Bk] = 0;
				}
			}

			if(controllers[p4].button_Y != -1) {

				if(tButtons[3].turboY == 1) {
					if(controllers[p4].button_Y == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_Y == XINPUT_GAMEPAD_START ||
						controllers[p4].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_Y & 0xFFFF))  keys[pl4Ytk] = 1;     else keys[pl4Ytk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Y]) keys[pl4Ytk] = 1;     else keys[pl4Ytk] = 0; 
				}
				else {
					if(controllers[p4].button_Y == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_Y == XINPUT_GAMEPAD_START ||
						controllers[p4].button_Y == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_Y == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_Y & 0xFFFF))  keys[pl4Yk] = 1;     else keys[pl4Yk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Y]) keys[pl4Yk] = 1;     else keys[pl4Yk] = 0; 

				}
			}


			if(controllers[p4].button_Start != -1) {
				if(controllers[p4].button_Start == XINPUT_GAMEPAD_BACK ||
					controllers[p4].button_Start == XINPUT_GAMEPAD_START ||
					controllers[p4].button_Start == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p4].button_Start == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[3].wButtons & (controllers[p4].button_Start & 0xFFFF))  keys[pl4startk] = 1;     else keys[pl4startk] = 0; 
				else
					if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Start]) keys[pl4startk] = 1;     else keys[pl4startk] = 0; 
			}

			if(controllers[p4].button_Right != -1) {
				if(tButtons[3].turboR == 1) {
					if(controllers[p4].button_Right == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_Right == XINPUT_GAMEPAD_START ||
						controllers[p4].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_Right & 0xFFFF))  keys[pl4Rtk] = 1;     else keys[pl4Rtk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Right]) keys[pl4Rtk] = 1;     else keys[pl4Rtk] = 0; 
				}
				else {
					if(controllers[p4].button_Right == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_Right == XINPUT_GAMEPAD_START ||
						controllers[p4].button_Right == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_Right == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_Right & 0xFFFF))  keys[pl4Rk] = 1;     else keys[pl4Rk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Right]) keys[pl4Rk] = 1;     else keys[pl4Rk] = 0; 
				}
			}


			if(controllers[p4].button_Left != -1) {
				if(tButtons[3].turboL == 1) {
					if(controllers[p4].button_Left == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_Left == XINPUT_GAMEPAD_START ||
						controllers[p4].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_Left & 0xFFFF))  keys[pl4Ltk] = 1;     else keys[pl4Ltk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Left]) keys[pl4Ltk] = 1;     else keys[pl4Ltk] = 0; 
				}
				else {
					if(controllers[p4].button_Left == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_Left == XINPUT_GAMEPAD_START ||
						controllers[p4].button_Left == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_Left == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_Left & 0xFFFF))  keys[pl4Lk] = 1;     else keys[pl4Lk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Left]) keys[pl4Lk] = 1;     else keys[pl4Lk] = 0; 
				}
			}

			if(controllers[p4].button_X != -1) {
				if(tButtons[3].turboX == 1) {
					if(controllers[p4].button_X == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_X == XINPUT_GAMEPAD_START ||
						controllers[p4].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_X & 0xFFFF))  keys[pl4Xtk] = 1;     else keys[pl4Xtk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_X]) keys[pl4Xtk] = 1;     else keys[pl4Xtk] = 0; 
				}
				else {
					if(controllers[p4].button_X == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_X == XINPUT_GAMEPAD_START ||
						controllers[p4].button_X == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_X == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_X & 0xFFFF))  keys[pl4Xk] = 1;     else keys[pl4Xk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_X]) keys[pl4Xk] = 1;     else keys[pl4Xk] = 0; 
				}
			}

			if(controllers[p4].button_A != -1) {
				if(tButtons[3].turboA == 1) {
					if(controllers[p4].button_A == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_A == XINPUT_GAMEPAD_START ||
						controllers[p4].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_A & 0xFFFF))  keys[pl4Atk] = 1;     else keys[pl4Atk] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_A]) keys[pl4Atk] = 1;     else keys[pl4Atk] = 0; 
				}
				else {
					if(controllers[p4].button_A == XINPUT_GAMEPAD_BACK ||
						controllers[p4].button_A == XINPUT_GAMEPAD_START ||
						controllers[p4].button_A == XINPUT_GAMEPAD_RIGHT_THUMB ||
						controllers[p4].button_A == XINPUT_GAMEPAD_LEFT_THUMB)
						if (g_Gamepads[3].wButtons & (controllers[p4].button_A & 0xFFFF))  keys[pl4Ak] = 1;     else keys[pl4Ak] = 0; 
					else
						if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_A]) keys[pl4Ak] = 1;     else keys[pl4Ak] = 0;
				}
			}

			if(controllers[p4].button_Select != -1) {
				if(controllers[p4].button_Select == XINPUT_GAMEPAD_BACK ||
					controllers[p4].button_Select == XINPUT_GAMEPAD_START ||
					controllers[p4].button_Select == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[p4].button_Select == XINPUT_GAMEPAD_LEFT_THUMB)
					if (g_Gamepads[3].wButtons & (controllers[p4].button_Select & 0xFFFF))  keys[pl4selk] = 1;     else keys[pl4selk] = 0; 
				else
					if (g_Gamepads[3].bAnalogButtons[controllers[p4].button_Select]) keys[pl4selk] = 1;     else keys[pl4selk] = 0; 
			}

			if (g_Gamepads[3].fY1 > 0 || g_Gamepads[3].wButtons & XINPUT_GAMEPAD_DPAD_UP)            keys[pl4upk] = 1;    else keys[pl4upk] = 0; 
			if (g_Gamepads[3].fY1 < 0 || g_Gamepads[3].wButtons & XINPUT_GAMEPAD_DPAD_DOWN)          keys[pl4downk] = 1;  else keys[pl4downk] = 0;
			if (g_Gamepads[3].fX1 < 0 || g_Gamepads[3].wButtons & XINPUT_GAMEPAD_DPAD_LEFT)          keys[pl4leftk] = 1;  else keys[pl4leftk] = 0;
			if (g_Gamepads[3].fX1 > 0 || g_Gamepads[3].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT)         keys[pl4rightk] = 1; else keys[pl4rightk] = 0;
		}



		//Utility Functions------------------------------------------------------------------------------------
		
		
		
		if(ShowFPS == 1) {
			if(controllers[0].button_ShowFPS != -1) {
				//dprintf("FPS != -1\n");	
				if( controllers[0].button_ShowFPS == XINPUT_GAMEPAD_RIGHT_THUMB ||
					controllers[0].button_ShowFPS == XINPUT_GAMEPAD_LEFT_THUMB) {
						if (g_Gamepads[0].wButtons & (controllers[0].button_ShowFPS & 0xFFFF)) {
							FPSAtStart ^= 1; FPSOn ^= 1; 
							//dprintf("FPS Buttons: %d\n", controllers[0].button_ShowFPS & 0xFFFF);
						}
						
				}
				else { 
					if (g_Gamepads[0].Event == controllers[0].button_ShowFPS) {
						FPSAtStart ^= 1; FPSOn ^= 1; 
						//dprintf("FPS Event: %d\n", controllers[0].button_ShowFPS);
					}
				}
			}
		}

		if(EnableAudioAdjust == 1) { 
			if (g_Gamepads[0].fY2 > 0) keys[KeyVolUp] = 1; else keys[KeyVolUp] = 0; 
			if (g_Gamepads[0].fY2 < 0) keys[KeyVolDown] = 1; else keys[KeyVolDown] = 0; 
		}
		else {
			keys[KeyVolUp] = 0;
			keys[KeyVolDown] = 0;
		}

		if(controllers[0].button_FastForward != -1) {
			if(controllers[0].button_FastForward == XINPUT_GAMEPAD_BACK ||
				controllers[0].button_FastForward == XINPUT_GAMEPAD_START ||
				controllers[0].button_FastForward == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[0].button_FastForward == XINPUT_GAMEPAD_LEFT_THUMB) {
				if (g_Gamepads[0].wButtons & (controllers[0].button_FastForward & 0xFFFF)) 
					keys[KeyFastFrwrd] = 1;  
				else 
					keys[KeyFastFrwrd] = 0; 
			}
			else { 
				if (g_Gamepads[0].bAnalogButtons[controllers[0].button_FastForward])
					keys[KeyFastFrwrd] = 1;  
				else  
					keys[KeyFastFrwrd] = 0; 
			}
		}

		if(controllers[0].button_SaveState != -1) {
			if(controllers[0].button_SaveState == XINPUT_GAMEPAD_BACK ||
				controllers[0].button_SaveState == XINPUT_GAMEPAD_START ||
				controllers[0].button_SaveState == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[0].button_SaveState == XINPUT_GAMEPAD_LEFT_THUMB) {
					if(!DisableSaveStates) {
						if (g_Gamepads[0].wButtons & (controllers[0].button_SaveState & 0xFFFF))  
							keys[KeySaveState] = 1;  
						else 
							keys[KeySaveState] = 0;
					}
			}	 
			else {
				if(!DisableSaveStates) {
						if (g_Gamepads[0].bAnalogButtons[controllers[0].button_SaveState])
							keys[KeySaveState] = 1;  
						else 
							keys[KeySaveState] = 0;
					}
			}
		}


		if(controllers[0].button_LoadState != -1) {
			if(controllers[0].button_LoadState == XINPUT_GAMEPAD_BACK ||
				controllers[0].button_LoadState == XINPUT_GAMEPAD_START ||
				controllers[0].button_LoadState == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[0].button_LoadState == XINPUT_GAMEPAD_LEFT_THUMB) {
					if(!DisableSaveStates) {
							if (g_Gamepads[0].wButtons & (controllers[0].button_LoadState & 0xFFFF))  
								keys[KeyLoadState] = 1; 
							else 
								keys[KeyLoadState] = 0;  
					}
			}  else { 
				if(!DisableSaveStates) {
					if (g_Gamepads[0].bAnalogButtons[controllers[0].button_LoadState]) 
						keys[KeyLoadState] = 1;
					else 
						keys[KeyLoadState] = 0; 
				}
			}
		}

		if(controllers[0].button_Rewind != -1) {
			if(controllers[0].button_Rewind == XINPUT_GAMEPAD_BACK ||
				controllers[0].button_Rewind == XINPUT_GAMEPAD_START ||
				controllers[0].button_Rewind == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[0].button_Rewind == XINPUT_GAMEPAD_LEFT_THUMB)
				if (g_Gamepads[0].wButtons & (controllers[0].button_Rewind & 0xFFFF))  keys[KeyRewind] = 1;  else keys[KeyRewind] = 0;  
			else
				if (g_Gamepads[0].bAnalogButtons[controllers[0].button_Rewind]) keys[KeyRewind] = 1;  else  keys[KeyRewind] = 0; 
		}
		
		int eXit = 0;
		
		if(controllers[0].button_ExitGame  != -1) {
			if(controllers[0].button_ExitGame == XINPUT_GAMEPAD_BACK ||
				controllers[0].button_ExitGame == XINPUT_GAMEPAD_START ||
				controllers[0].button_ExitGame == XINPUT_GAMEPAD_RIGHT_THUMB ||
				controllers[0].button_ExitGame == XINPUT_GAMEPAD_LEFT_THUMB) {
				if (g_Gamepads[0].wButtons & (controllers[0].button_ExitGame & 0xFFFF))  
					eXit = 1; 
			}
			else {
				if (g_Gamepads[0].bAnalogButtons[controllers[0].button_ExitGame]) eXit = 1; 
			}
		}
		


		if(disableCombo == 0) { 
			if ((g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
				(g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_BACK)) {  
					if(!DisableSaveStates)keys[KeySaveState] = 1; 
			}

			if ((g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && 
				(g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_BACK)) {  
					if(!DisableSaveStates)keys[KeyLoadState] = 1; 
			}

				/*
			//fast forward
			if ((g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
				(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) &&
				(g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START)) {  
					keys[KeyFastFrwrd] = 1;
			}

			//rewind
			if ((g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
				(g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) &&
				(g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_BACK)) {  
					keys[KeyRewind] = 1;
			}
			*/


			//m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_START
			if(  
				(g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_BACK) &&
				(g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )
				) { eXit = 1; }
		}

		if (eXit){


			//drawHack();
			//dprintf("Stop A:\n");
			lpPrimaryBuffer->Stop(); 
			
			//dprintf("Stop B:\n");
			optionSelected = 0;
			//dprintf("Stop C:\n");
			asm_call(SaveSramData);
			//dprintf("Stop D:\n");
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			//dprintf("Stop E:\n");
			Clear2xSaIBuffer();
			//dprintf("Stop F:\n");
			//showMemory();
			Device->Present(NULL,NULL,NULL,NULL);  
			//dprintf("Stop G:\n");
			LoopMode = 2; 
			//dprintf("Stop H:\n");
			SoundEnabled = 0;
			//dprintf("Stop I:\n");
			screenOptions = 1;
			//dprintf("Stop J:\n");
			inGame = 1;

			firstExit = 1;
			//dprintf("Stop K:\n");
			//FileMenu.scan();
			//dprintf("Stop L:\n\n\n\n\n\n");
			//restoreResolution();


			//asm_call(SaveSramData);
			//	Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			//	Clear2xSaIBuffer();
			//	Device->Present(NULL,NULL,NULL,NULL);  
			//	GUIOn2 = 1; LoopMode = 2; FileMenu.scan(); resumeMusic(); lpPrimaryBuffer->Stop(); SoundEnabled = 0; screenOptions = 1; inGame = 1;

		}

	}

	void screenShotTexture() {
			
			DWORD *SURFDW;
			ScreenPtr=vidbuffer;   
			ScreenPtr+=16*2+32*2+256*2;
			TexScreenShot->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			SurfBufD=(DWORD) &SurfBuf[0];
			SURFDW=(DWORD *) &SurfBuf[0];
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 0;
			hqFilter = 0;
			antienab = 0;
			SurfaceX = 320;
			SurfaceY = 240;
			DrawWin320x240x16();
			TexScreenShot->UnlockRect(0);
	}

	
	void UpdateVFrame(void)
	{
		WinUpdateDevices();
		CheckTimers();
		//if(LoopMode == 2) return;
		if (SoundEnabled == 0) { return; }
		lpPrimaryBuffer->GetCurrentPosition(&CurrentPos,&WritePos);
		if (LastUsedPos <= CurrentPos)
			DataNeeded=CurrentPos-LastUsedPos;
		else
			DataNeeded=SoundBufferSize - LastUsedPos + CurrentPos;

		DataNeeded /=(512); //2 * 256 (2 * 128 (2 * 64 (2 * 32 (2 * 16 (2 * 8 ( 2 * 4 ( 2 * 2 (2 * 1
		DataNeeded *=(512);
		//0000 0001 0000 0000
		while (DataNeeded>0)
		{
			asm_call(SoundProcess);
			DSPBuffer1=(int *)&DSPBuffer;
			buffer_ptr = (int)&Buffer[0];
			ASM_BEGIN
				ASM_COMMAND3(mov esi,DSPBuffer1)
				ASM_COMMAND3(mov edi,buffer_ptr)
				ASM_COMMAND3(mov ecx,256)
				ASM_COMMAND2(shr ecx,2)
				ASM_COMMAND(_top_mmx:)
				ASM_COMMAND2(movq mm0,[esi])
				ASM_COMMAND2(packssdw mm0,[esi+8])
				ASM_COMMAND2(movq [edi],mm0)
				ASM_COMMAND2(add esi,16)
				ASM_COMMAND2(add edi,8)
				ASM_COMMAND(dec ecx)
				ASM_COMMAND(jne _top_mmx)
				ASM_COMMAND(emms)
				ASM_END
				lpPrimaryBuffer->Lock(LastUsedPos,512, &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0);
			memcpy(lpvPtr1, &Buffer[0], dwBytes1); if (NULL != lpvPtr2) memcpy(lpvPtr2, &Buffer[0]+dwBytes1, dwBytes2);
			LastUsedPos+=512;
			if (LastUsedPos==SoundBufferSize) LastUsedPos=0;
			DataNeeded-=(512);
		}
	}

	extern "C" {
		//extern unsigned char scanlines;
		extern unsigned char cfgscanline;
	}



	/*
	void (*HM7)() = NULL;
	void (*AdvMame)() = NULL;
	void (*AdvMameHM7)() = NULL;
	void (*Simple2X)() = NULL;
	void (*Simple2XHM7)() = NULL;
	void (*twoXSAI)() = NULL;
	void (*Super2XSAI)() = NULL;
	void (*SuperEagle)() = NULL;
	void (*None)() = NULL;
	void (*None25SL)() = NULL;
	void (*None50SL)() = NULL;
	void (*None100SL)() = NULL;
	void (*Interp)() = NULL;
	void (*Interp25SL)() = NULL;
	void (*Interp50SL)() = NULL;
	void (*Interp100SL)() = NULL;
	void (*HQ2X)() = NULL;
	*/


	void drawscreenwin(void)
	{
		UpdateVFrame();

		if (curblank!=0) return;

		

		//firstVidRender gets set to 1 on a filter 
		//change to have ZSNES do 1 frame of black to
		//clear out any previous graphics in vidbuffer
		//EmuScreen is a temporary buffer used for filters not supported by ZSNES.
		
		
		if(firstVidRender < 5) {
			//ClearWin16();
			asm_call(Clear2xSaIBuffer);
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 0;
			hqFilter = 0;
			antienab = 0;
			firstVidRender++;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= (unsigned char*) &(SurfBuf[(240-resolutn)*pitch+128]);
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}
		


		if(SoftwareFilter == 11) {
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 0;
			antienab = 0;
			hqFilter = 0;
			ScreenPtr=vidbuffer;
			ScreenPtr+=608;
			pitch = 1280; 
			En2xSaI = 0;
			SurfaceX = 320;
			SurfaceY = 240;
			SurfBufD=(DWORD) &EmuScreen[0];


			

			DrawWin320x240x16();


			AdvMame2x((unsigned char*)&EmuScreen[640], 1280,
				SurfBuf, lockScreen.Pitch, 320, 239);


			
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}

		if (SoftwareFilter == 12) {//Simple 2x
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 0;
			hqFilter = 0;
			antienab = 0;
			ScreenPtr=vidbuffer;
			ScreenPtr+=608;
			pitch = 1280; 
			En2xSaI = 0;
			SurfaceX = 320;
			SurfaceY = 240;
			SurfBufD=(DWORD) &EmuScreen[0];
			DrawWin320x240x16();
			nSimple2x((unsigned char*)&EmuScreen[0], 1280, 0,
				SurfBuf, lockScreen.Pitch, 320, 240);	
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}

		if(SoftwareFilter == 10) {//Super 2xsai
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 3;
			scanlines = 0;
			hqFilter = 0;
			antienab = 0;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= &SurfBuf[(240-resolutn)*pitch+64*2];
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}

		if(SoftwareFilter == 0) {//no filter
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 0;
			hqFilter = 0;
			antienab = 0;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= &SurfBuf[(240-resolutn)*pitch+64*2];
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}

		if(SoftwareFilter == 13) {//no filter
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 0;
			hqFilter = 0;
			antienab = 0;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= &SurfBuf[(240-resolutn)*pitch+64*2];
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}
		if(SoftwareFilter == 1) {//scanlines
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 2;
			hqFilter = 0;
			antienab = 0;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= &SurfBuf[(240-resolutn)*pitch+64*2];
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}
		if(SoftwareFilter == 2) {//scanlines
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 3;
			hqFilter = 0;
			antienab = 0;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= &SurfBuf[(240-resolutn)*pitch+64*2];
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}
		if(SoftwareFilter == 3) {//scanlines
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 1;
			hqFilter = 0;
			antienab = 0;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= &SurfBuf[(240-resolutn)*pitch+64*2];
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}

		if(SoftwareFilter == 4) {//Interpolation with scanlines
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 0;
			hqFilter = 0;
			antienab = 1;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= &SurfBuf[(240-resolutn)*pitch+64*2];
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}


		if(SoftwareFilter == 5) {//Interpolation with scanlines
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 2;
			hqFilter = 0;
			antienab = 1;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= &SurfBuf[(240-resolutn)*pitch+64*2];
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}


		if(SoftwareFilter == 6) {//Interpolation with scanlines
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 3;
			hqFilter = 0;
			antienab = 1;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= &SurfBuf[(240-resolutn)*pitch+64*2];
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}

		if(SoftwareFilter == 7) {//Interpolation
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			En2xSaI = 0;
			scanlines = 1;
			hqFilter = 0;
			antienab = 1;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= &SurfBuf[(240-resolutn)*pitch+64*2];
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}
		
		if(SoftwareFilter == 9) {//2xsai
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 2;
			scanlines = 0;
			hqFilter = 0;
			antienab = 0;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= &SurfBuf[(240-resolutn)*pitch+64*2];
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}
		if(SoftwareFilter == 8) {//Super Eagle
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 1;
			scanlines = 0;
			hqFilter = 0;
			antienab = 0;
			AddEndBytes=pitch-1024;
			NumBytesPerLine=pitch;
			WinVidMemStart= &SurfBuf[(240-resolutn)*pitch+64*2];
			asm_call(copy640x480x16bwin);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}

		if(SoftwareFilter == 15) {
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 1;
			En2xSaI = 0;
			scanlines = 0;
			antienab = 0;
			hqFilter = 0;
			ScreenPtr=vidbuffer;
			ScreenPtr+=608;//(16*2)+(32*2)+(256*2); 32 + 64 + 512
			pitch = 1280; 
			En2xSaI = 0;
			SurfaceX = 320;
			SurfaceY = 240;
			SurfBufD=(DWORD) &EmuScreen[0];
			DrawWin320x240x16();
			AdvMame2x((unsigned char*)&EmuScreen[640], 1280,
				SurfBuf, lockScreen.Pitch, 320, 239);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}

		if (SoftwareFilter == 14) {//Simple 2x
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 1;
			En2xSaI = 0;
			scanlines = 0;
			hqFilter = 0;
			antienab = 0;
			ScreenPtr=vidbuffer;
			ScreenPtr+=16*2+32*2+256*2;
			pitch = 1280; 
			En2xSaI = 0;
			SurfaceX = 320;
			SurfaceY = 240;
			SurfBufD=(DWORD) &EmuScreen[0];
			DrawWin320x240x16();
			nSimple2x((unsigned char*)&EmuScreen[0], 1280, 0,
				SurfBuf, lockScreen.Pitch, 320, 240);	
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
		}

		if(SoftwareFilter == 16) {//hq2x
			/*
			
			Mode7HiRes16b = 0;
			En2xSaI = 0;
			scanlines = 0;
			antienab = 0;
			hqFilter = 0;
			ScreenPtr=vidbuffer;
			ScreenPtr+=16*2+32*2+256*2;
			pitch = 1280; 
			En2xSaI = 0;
			SurfaceX = 320;
			SurfaceY = 240;
			SurfBufD=(DWORD) &EmuScreen[0];
			DrawWin320x240x16();
			SuperScale((unsigned char*)EmuScreen, 1280, 0, (unsigned char*)lockScreen.pBits, lockScreen.Pitch, 320, 240);
			//SuperScale(uint8 *src, uint32 srcpitch, uint8 *,uint8 *dst, uint32 dstpitch, int width, int height);
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;
			
			
			*/
			
			
			
			TexScreen->LockRect( 0, &lockScreen, 0, 0L );
			SurfBuf = (BYTE*)lockScreen.pBits;
			pitch = lockScreen.Pitch;
			Mode7HiRes16b = 0;
			En2xSaI = 1;
			scanlines = 0;
			antienab = 0;
			hqFilter = 1;
			SurfaceX = 256*2;
			SurfaceY = 224*2;
			BitDepth = 16;
			NumBytesPerLine = pitch;
			AddEndBytes = pitch - SurfaceX*(BitDepth/8);
			WinVidMemStart=&SurfBuf[(240-resolutn)*pitch+64*2];
			hq2x_16b();
			TexScreen->UnlockRect(0);
			Device->Clear( 0, NULL, D3DCLEAR_TARGET,0, 1.0f, 0L );
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->Present(NULL,NULL,NULL,NULL);  
			return;			
		}
}

}//end of extern "C"
